#ifndef CE2_ECPKI_KG_H
#define CE2_ECPKI_KG_H

/*
 *  Object name     :  CE2_ECPKI_KG.h
 *  State           :  %state%
 *  Creation date   :  02.02.2006
 *  Last modified   :  %modify_time%
 */
/** @file
 * \brief Defines the API of a function for generating ECC private and public keys.
 *
 *  \version CE2_ECPKI_KG.h#1:cinc:1
 * \author R.Levin
 * \remarks Copyright (C) 2006 by Discretix Technologies Ltd. All rights reserved.
 */

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif


/**
****************************************************************
* Function Name: 
*  CE2_ECPKI_GenKeyPair
*
* Inputs:
* @param DomainID [in] - The enumerator variable defines the current EC domain;
* @param UserPrivKey_ptr [out] - A pointer to the output private key structure.
* @param UserPublKey_ptr [out] - A pointer to the otput public key structure.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_ECPKI_GEN_KEY_INVALID_PRIVATE_KEY_PTR_ERROR
*   - CE2_ECPKI_GEN_KEY_INVALID_PUBLIC_KEY_PTR_ERROR
*   - CE2_ECPKI_GEN_KEY_ILLEGAL_DOMAIN_ID_ERROR
*
* \brief \b 
* Description:
*  This function generate new key pair for ECC.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Initialize output structures;
*  -# Call low level function LLF_ECPKI_GenKeyPair 
*     for generation of new key pair with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_ECPKI_GenKeyPair(
				    	CE2_ECPKI_DomainID_t  	    DomainID,	        /*in*/   
				    	CE2_ECPKI_UserPrivKey_t   *UserPrivKey_ptr,    /*out*/
				 	CE2_ECPKI_UserPublKey_t   *UserPublKey_ptr    /*out*/);

				              

#ifdef __cplusplus
}
#endif

#endif




